IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_ventas_socios_actividades]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_ventas_socios_actividades] 
END
GO

Create PROCEDURE [dbo].[CPJ_ventas_socios_actividades]	@pJsonRecibido VARCHAR(8000)
AS

SET NOCOUNT ON

DECLARE @pFechaDesde			DATETIME,
		@pFechaHasta			DATETIME,
		@pId_Unid_Negocio       VARCHAR(10),
		@pClientes_activos      TINYINT,
		@pUsuario               INT,
		@pId_Familia            INT,
		@pId_Producto           VARCHAR(14),
        @pOrden                 CHAR(10)

		DECLARE @Sql		    VARCHAR(MAX)
		DECLARE @SqlSelect		VARCHAR(MAX)
		DECLARE @SqlFrom	    VARCHAR(MAX)
		DECLARE @SqlWhere		VARCHAR(MAX)
		DECLARE @SqlOrden   	VARCHAR(MAX)
		DECLARE @sqlgroup       VARCHAR(MAX)
		DECLARE @SqlHaving      VARCHAR(MAX)

		/*Fin Variables Locales*/


		SET @pId_Unid_Negocio			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Unid_Negocio')),'')
		SET @pFechaDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaDesde')),GETDATE())
		SET @pFechaHasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaHasta')),GETDATE())
		SET @pClientes_activos			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Clientes_activos')),0)
		SET @pUsuario		        	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Usuario')),0)
		SET @pOrden				     	= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Orden')),'')
		SET @pId_Familia				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Familia')),0)
		SET @pId_Producto				= ISNULL(CONVERT(CHAR(14), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Producto')),'')
 

     Select * Into #Prod_Familias From Prod_Familias
	 If @pId_Familia <> 0
	     DELETE #Prod_Familias WHERE Id_Familia <>@pId_Familia 


 
Select K.Activo,K.Id_cliente, K.Id_Cliente_Externo AS Nro_Socio, K.Razon_Social, K.Id_Tipo_Doc, K.Doc_Nro, K.Fecha_Nac
      , dbo.CF_Edad_Persona_A_UnaFecha(K.Fecha_Nac,GETDATE()) as Edad
      , K.Sexo 
	  , CASE ISNULL(K.Id_Cliente_Ref,0)
	         WHEN 0 THEN 'TITULAR'
	         ELSE 'INTEGRANTE'
	    END AS Grupo
	  , CASE ISNULL(K.Id_Cliente_Ref,0)
	         WHEN 0 THEN K.Razon_Social
	         ELSE TIT.Razon_Social
	    END AS Titular
	  , K.Id_Tipo_cli,CT.Descripcion as Categoria
	  , K.Ult_Cuota_Paga
	  , convert(varchar,K.Email) as Email
	  , convert(varchar,ISNULL(K.Tel_Movil,'')) AS Telefono
	  , K.Fecha_Alta,ISNULL(K.Fecha_Baja,'') AS Fecha_Baja
	  , K.Id_Motivo_Est
	  , M.Descripcion AS Motivo_Baja 
	  , F.Descripcion as Actividad
	  , I.Fecha_QA 
 INTO #Reporte
 From Clientes K
		LEFT JOIN Cbtes_Items I ON I.Id_Cliente  = K.Id_Cliente AND I.Id_Cliente <> 0
		JOIN Cbtes C  ON C.Id_Trans = I.Id_Trans AND C.Id_Estado_Cbte Not In (0,3)
		JOIN Cbtes_tipos T ON C.Id_Tipo_Cbte = T.Id_Tipo_Cbte And T.Compromete_Factura in (1,-1)
		JOIN Productos P   ON P.Id_Producto  = I.Id_Producto 
        JOIN #Prod_Familias F  ON F.Id_Familia = P.Id_Familia
		JOIN Clientes TIT  ON TIT.Id_Cliente = K.Id_Cliente_Ref
		JOIN Clientes_Tipos CT ON CT.Id_Tipo_Cli = K.Id_Tipo_Cli
		JOIN Estados_Motivos M ON M.Id_Motivo_Estado = K.Id_Motivo_Est
    Where I.Fecha_QA >= @pFechaDesde 
	      AND i.Fecha_QA < dateadd(dd,1,@pFechaHasta)
	

-----------------------------------------------------------------------------------------------------------------------------------------------
--| MajorVersion | Producto                  | Notas                        |
--| ------------ | ------------------------- | ---------------------------- |
--| 8            | SQL Server 2000           |                              |
--| 9            | SQL Server 2005           |                              |
--| 10           | SQL Server 2008 / 2008 R2 | 10.0 → 2008; 10.50 → 2008 R2 |
--| 11           | SQL Server 2012           |                              |
--| 12           | SQL Server 2014           |                              |
--| 13           | SQL Server 2016           |                              |
--| 14           | SQL Server 2017           |                              |
--| 15           | SQL Server 2019           |                              |
--| 16           | SQL Server 2022           |                              |

-----------------------------------------------------------------------------------------------------------------------------------------------
 
 		Select K.Activo,K.Id_Cliente, Nro_Socio, K.Razon_Social, K.Id_Tipo_Doc, K.Doc_Nro, K.Fecha_Nac
			   , Edad
			   , K.Sexo 
			   , Grupo
			   , Titular
			   , K.Id_Tipo_cli, Categoria
			   , K.Ult_Cuota_Paga, K.Email, Telefono
			   , K.Fecha_Alta, Fecha_Baja
			   , K.Id_Motivo_Est, Motivo_Baja 
			INTO #Consulta
		  From #Reporte K
		  
	ALTER TABLE #Consulta ADD  Actividad VARCHAR(MAX)

	DECLARE @MajorVersion INT

	SELECT @MajorVersion = CAST(
								LEFT(
									CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(50)),
									CHARINDEX('.', CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(50))) - 1
								) 
							AS INT) 


	IF @MajorVersion >= 13  --2016
		SET @Sql = ' Insert INTO #Consulta
		Select K.Activo,K.Id_Cliente, Nro_Socio, K.Razon_Social, K.Id_Tipo_Doc, K.Doc_Nro, K.Fecha_Nac
			   , Edad
			   , K.Sexo 
			   , Grupo
			   , Titular
			   , K.Id_Tipo_cli, Categoria
			   , K.Ult_Cuota_Paga, K.Email, Telefono
			   , K.Fecha_Alta, Fecha_Baja
			   , K.Id_Motivo_Est, Motivo_Baja 
			   , STRING_AGG(Actividad + '' '' + left(Convert(char(8),Fecha_QA,112),6), '', '') as Actividad
		  From #Reporte K
		  GROUP BY 
		  K.Activo,K.Id_cliente, K.Nro_Socio , K.Razon_Social, K.Id_Tipo_Doc, K.Doc_Nro, K.Fecha_Nac
			   , Edad
			   , K.Sexo 
			   , Grupo
			   , Titular
			   , K.Id_Tipo_cli
			   , Categoria
			   , K.Ult_Cuota_Paga
			   , K.Email
			   , K.Telefono
			   , K.Fecha_Alta,K.Fecha_Baja
			   , K.Id_Motivo_Est
			   , K.Motivo_Baja' 
	
	ELSE
		SET @Sql = ';WITH CTE_Claves AS (
			SELECT DISTINCT         Activo,			Id_Cliente,			Nro_Socio,			Razon_Social,			Id_Tipo_Doc,
									Doc_Nro,        Fecha_Nac,			Edad,				Sexo,					Grupo,
									Titular,        Id_Tipo_cli,        Categoria,			Ult_Cuota_Paga,			Email,
									Telefono,       Fecha_Alta,			Fecha_Baja,			Id_Motivo_Est,			Motivo_Baja
			FROM #Reporte
		)
		INSERT INTO #Consulta
		SELECT  K.Activo,	K.Id_Cliente,    K.Nro_Socio,   K.Razon_Social,		K.Id_Tipo_Doc,
				K.Doc_Nro,  K.Fecha_Nac,	 K.Edad,		K.Sexo,				K.Grupo,    
				K.Titular,	K.Id_Tipo_cli,   K.Categoria,   K.Ult_Cuota_Paga,   K.Email,
				K.Telefono, K.Fecha_Alta,    K.Fecha_Baja,  K.Id_Motivo_Est,    K.Motivo_Baja,

			STUFF((
				SELECT
					'', '' + R.Actividad
						  + '' '' + LEFT(CONVERT(CHAR(8), R.Fecha_QA, 112), 6)
				FROM #Reporte AS R
				WHERE
					R.Id_Cliente    = K.Id_Cliente
				FOR XML PATH(''''), TYPE
			).value(''.'', ''NVARCHAR(MAX)'')
			, 1, 2, ''''  -- elimina la coma y espacio iniciales
			) AS Actividad
		FROM CTE_Claves AS K;'

	EXEC(@Sql)


----------------------------------------------------------------------------------------------------------------------


		SET @Sql	    = ''
		SET @SqlSelect	= ''
		SET @SqlFrom	= ''
		SET @SqlWhere	= ''
		SET @SqlOrden	= ''
		SET @sqlgroup   = ''
		SET @SqlHaving  = ''

      SET @SqlSelect	= 'SELECT * FROM #CONSULTA'
	  SET @SqlWhere	= 'WHERE 1=1 '

	  IF @pClientes_activos = 1
	     SET @SqlWhere	+= ' AND ACTIVO = 1 '
      
      IF @pOrden = 'N'
	     SET @SqlOrden	= 'ORDER BY Razon_Social'

      IF @pOrden = 'C'
	     SET @SqlOrden	= 'ORDER BY Nro_Socio'

	  SET @Sql = @SqlSelect + ' ' + @SqlWhere + ' ' + @SqlOrden
	  EXEC(@sql) 

Drop Table #Reporte
Drop Table #Consulta
Drop Table #Prod_Familias


/*

EXEC CPJ_ventas_socios_actividades '{"FechaDesde":"20220513","FechaHasta":"20230613","Id_Unid_Negocio":"","Filtrar_con_saldo":"1"
,"Clientes_activos":"1","Id_Producto":"","Id_Familia":"","Orden":"N","Formato":"PC"}'  

*/